﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.IO;
using System.Windows.Forms;

namespace 電子文書回覧追跡ツール {
    static class CommonParameter {
        public static string folder;
        public static string message;
        /// <summary>
        /// commonparameterを読み込みdatasetを返す
        /// </summary>
        /// <returns></returns>
        public static DataSet read() {
            message = "";
            folder = "";
            DataSet dataSet1 = new DataSet();
            try {
                dataSet1.ReadXml(Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "CachedCommonParameter.xml"));
                try {
                    folder = dataSet1.Tables["構成"].Rows[0]["共通パラメータフォルダ"].ToString();
                    message = "共通パラメータ入手先：指定された場所";
                }
                catch {
                    folder = @"\\tbanvisv63\documentcontrol";
                    message = "共通パラメータ入手先：固定の想定サーバ";
                }
            }
            catch {
                message = "共通パラメータ入手先：固定の想定サーバー";
                folder = @"\\tbanvisv63\documentcontrol";
            }
            try {
                //読込
                dataSet1 = new DataSet();
                dataSet1.ReadXml(Path.Combine(folder, "commonparameter.xml"));
                //Cacheとして保存
                using(System.IO.StreamWriter strm = new System.IO.StreamWriter(Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "CachedCommonParameter.xml"), false, System.Text.Encoding.UTF8)) {
                    for(bool writed=false; !writed; ) {
                        try {
                            dataSet1.WriteXml(strm);
                            writed = true;
                        }
                        catch {
                            System.Threading.Thread.Sleep(1500);
                        }
                    }
                }
            }
            catch(Exception) {
                folder = System.AppDomain.CurrentDomain.BaseDirectory;
                message = "共通パラメータ入手先：ローカルキャッシュ";
                dataSet1.ReadXml(Path.Combine(folder, "CachedCommonParameter.xml"));
            }
            return dataSet1;
        }

        /// <summary>
        /// datasetをcommonparameterに書き出す
        /// </summary>
        /// <param name="dataset1"></param>
        public static void write(DataSet dataset1) {
            DialogResult ans = MessageBox.Show(folder + "に保存します。良いですか？","確認", MessageBoxButtons.OKCancel );
            if(ans == DialogResult.OK) {
                System.IO.StreamWriter strm;
                try {
                    if(folder == System.AppDomain.CurrentDomain.BaseDirectory) {
                        strm = new System.IO.StreamWriter(Path.Combine(folder, "CachedCommonParameter.xml"), false, System.Text.Encoding.UTF8);
                    }
                    else {
                        strm = new System.IO.StreamWriter(Path.Combine(folder, "commonparameter.xml"), false, System.Text.Encoding.UTF8);
                    }
                    dataset1.WriteXml(strm);
                    strm.Close();
                    MessageBox.Show("共通パラメータ(commonparameter.xml)を\r" + folder + "\rへ保存しました");
                }
                catch(Exception ex) {
                    MessageBox.Show("共通パラメータ(commonparameter.xml)は、\r" + folder + "\rへの保存が出来ませんでした\r\r" + ex.Message, "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }
    }
}
